CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 

    IF NOT EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'est_prod_ncm_cadastro_comb_pobreza') THEN 
		CREATE TABLE est_prod_ncm_cadastro_comb_pobreza (
				nr_ncm varchar(50) NOT NULL,
				uf varchar(10) NOT NULL,
				perc_aliq numeric(14, 4) NOT NULL DEFAULT 0,
				CONSTRAINT pk_est_prod_ncm_cadastro_comb_pobreza PRIMARY KEY (nr_ncm, uf)
		)
		WITH (
			OIDS=FALSE
		);	
		RAISE NOTICE 'Tabela est_prod_ncm_cadastro_comb_pobreza criada' ;
	ELSE 
		RAISE NOTICE 'Tabela est_prod_ncm_cadastro_comb_pobreza já existe' ;
    END IF; 

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();



